<?php
/***************************************************************************
* copyright            : (C) 2001-2004 Advanced Internet Designs Inc.
* email                : forum@prohost.org
* $Id: err.inc.t,v 1.35 2004/01/04 16:38:26 hackie Exp $
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
***************************************************************************/

function error_dialog($title, $msg, $level='WARN', $ses=null)
{
	if (!$ses) {
		$ses = (int) $GLOBALS['usr']->sid;
	}

	$error_msg = '[Error] '.$title.'<br />';
	$error_msg .= '[Message Sent to User] '.trim($msg).'<br />';
	$error_msg .= '[User IP] '.get_ip().'<br />';
	$error_msg .= '[Requested URL] http://';
	$error_msg .= isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '';
	$error_msg .= isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
	$error_msg .= '<br />';

	if (isset($_SERVER['HTTP_REFERER'])) {
		$error_msg .= '[Referring Page] '.$_SERVER['HTTP_REFERER'].'<br />';
	}
	error_log('['.gmdate('D M j G:i:s T Y', __request_timestamp__).'] '.base64_encode($error_msg)."\n", 3, $GLOBALS['ERROR_PATH'].'fud_errors');

	ses_putvar($ses, array('er_msg' => $msg, 'err_t' => $title));

	if (is_int($ses)) {
		if ($GLOBALS['FUD_OPT_2'] & 32768) {
			header('Location: http://alt.org/forum/index.php/e/'._rsidl);
		} else {
			header('Location: http://alt.org/forum/index.php?t=error&'._rsidl);
		}
	} else {
		if ($GLOBALS['FUD_OPT_2'] & 32768) {
			header('Location: http://alt.org/forum/index.php/e//'.$ses);
		} else {
			header('Location: http://alt.org/forum/index.php?t=error&S='.$ses);
		}
	}
	exit;
}

function std_error($type)
{
	if (!isset($_SERVER['HTTP_REFERER'])) {
		$_SERVER['HTTP_REFERER'] = 'unknown';
	}

	$ses_id = s;
	$usr_d->email = $GLOBALS['usr']->email;

	$err_array = array(
'ERR_login'=>array('ERROR: You are not logged in', 'You are not logged in, please do so<br><br>If you would like to register go to the <a href="http://alt.org/forum/index.php?t=register&amp;'._rsid.'">registration form</a><br>If you would like to login please go to the <a href="http://alt.org/forum/index.php?t=login&amp;'._rsid.'">login form</a>'),
'ERR_disabled'=>array('Disabled feature', 'This feature has been disabled by the system administrator'),
'ERR_access'=>array('ERROR: Insufficient Permissions', 'You do not have the required permissions to perform this action'),
'ERR_registration_disabled'=>array('Registration Disabled', 'The administrator has disabled registration, please try again later'),
'ERR_user'=>array('ERROR: No such user', 'There is no such user'),
'ERR_perms'=>array('Permission Denied!', 'Your user permissions do not allow you to perform the action you are attempting.'),
'ERR_systemerr'=>array('ERROR: System Error', 'System error has occurred, please report it to the <a href="mailto:'.$GLOBALS['ADMIN_EMAIL'].'">webmaster</a>.'),
'ERR_emailconf'=>array('ERROR: Your account is not yet confirmed', 'You have not confirmed your account via email yet<br><table border=0><tr><td><ol><li>If you have not received a confirmation email <a href="http://alt.org/forum/index.php?t=reset&amp;email='.$usr_d->email.'&amp;S='.$ses_id.'">click here</a><li>If '.$usr_d->email.' is not your correct email address <a href="http://alt.org/forum/index.php?t=register&amp;S='.$ses_id.'">click here</a></ol></td></tr></table>')
);

	$err = $err_array['ERR_'.$type];
	if (is_array($err)) {
		error_dialog($err[0], $err[1]);
	} else {
		error_dialog('CRITICAL ERROR', 'You have encountered an error, but unfortunately there is a problem with the error reporting system');
	}
}

function std_out($text, $level='INFO')
{
	$fp = fopen($GLOBALS['ERROR_PATH'].'std_out.log', 'ab');
	$log_str = gmdate("Y-m-d-H-i-s", __request_timestamp__);
	$log_str .= " [".$level."] ";
	$log_str .= str_replace("\n", ' ', str_replace("\r", ' ', $text))."\n";
	fwrite($fp, $log_str);
	fclose($fp);
	@chmod($GLOBALS['ERROR_PATH'].'std_out.log',($GLOBALS['FUD_OPT_2'] & 8388608 ? 0600 : 0666));
}

function invl_inp_err()
{
	error_dialog('Invalid Input', 'You&#39;ve followed an invalid link, please notify the <a href="mailto:'.$GLOBALS['ADMIN_EMAIL'].'">webmaster</a>');
}
?>